package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Persistent extends Modifier {
	private static String xmlID = "PERSISTENT";

	public Persistent(Element root) {
		super(root, Persistent.xmlID);
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		} 

        if (forceAllow()) return ret;
		if (o.getXMLID().equals("COMBAT_LEVELS")) {
			return getDisplay()
					+ " cannot be applied to Combat Skill Levels of any form.";
		}  
		if (GenericObject
				.findObjectByID(o.getAssignedModifiers(), "UOO") != null) {
			return "";
		}  
		if (o.getEndUsage() > 0) {
			if (HeroDesigner.getActiveTemplate().is6E()) {
				if (!o.costsENDToMaintain()) {
					return getDisplay()
							+ " cannot be applied to Powers which cost END only to Activate.";
				}
			} else {
				return getDisplay()
						+ " cannot be applied to Powers which cost END.";
			}
		}  
		if (HeroDesigner.getActiveTemplate().is6E()
				&& o.getDuration().equals("INSTANT") && !o.continuingEffect()) {
			return getDisplay()
					+ " cannot be applied to Instant Powers -- apply Constant first.";
		}  
		if (o.getDuration().equals("PERSISTENT")
				|| o.getOrigDuration().equals("PERSISTENT")) {
			return o.getDisplay() + " is already Persistent.";
		}  
		if (o.getDuration().equals("INHERENT")
				&& (GenericObject.findObjectByID(o.getAssignedModifiers(),
						"INHERENT") == null)) {
			return o.getDisplay() + " is already Inherent.";
		}
		return ret;
	}
}